#include <iostream>
#include <unordered_set>
#include <vector>

const int MOD = 998244353;

int main() {
    std::string S;
    std::cin >> S;

    int N = S.length();
    std::unordered_set<int> seen;
    std::vector<int> prefixXor(N + 1, 0);

    // ???????????? ????????? XOR ?????????
    for (int i = 0; i < N; ++i) {
        prefixXor[i + 1] = prefixXor[i] ^ (S[i] - '0');
    }

    // ???????? ???? ?????????? XOR ?????????
    for (int l = 0; l < N; ++l) {
        for (int r = l; r < N; ++r) {
            int xorValue = prefixXor[r + 1] ^ prefixXor[l];
            seen.insert(xorValue);
        }
    }

    std::cout << seen.size() % MOD << std::endl;

    return 0;
}